# Two-Sector Economic Model with Environmental Policy

This repository contains MATLAB code for simulating and analyzing a two-sector economic model (green and brown sectors) with environmental policy implications.

## Files Description

- `main_2sector2_loop.m`: Main script that runs the simulation and generates plots
- `find_KG.m`: Function to solve for the green sector capital allocation
- `export_fig2.m`: Helper function for exporting figures with proper formatting
- `figure_heading.m`: Sets up consistent figure styling and formatting

## Model Parameters

The model includes several key parameters:
- `alphaB` (0.4): Capital share in brown sector production
- `alphaG` (0.3): Capital share in green sector production
- `varphi` (0.5): Scale of emissions function
- `phi1` (1), `phi2` (2): Parameters in abatement cost function
- `kappa` (0.5): Share of brown sector relative to green sector
- `theta` (6): Elasticity of substitution between sectors

## Generated Plots

The code generates 13 different plots showing how various economic variables respond to changes in carbon tax rates (`pZ`):
- Emissions level (Z)
- Abatement effort (U)
- Sectoral outputs (YB, YG)
- Capital returns (rB, rG)
- Wage rates (wB, wG)
- Prices (pB, pG)
- Capital allocation (KB, KG)
- Total output (Y)

## Usage

1. Ensure all files are in the same directory
2. Run `main_2sector2_loop.m` in MATLAB
3. The script will generate PDF files for each plot in your working directory

## Requirements

- MATLAB (with optimization toolbox for `fsolve`)
- LaTeX installation (for proper rendering of mathematical symbols in plots)

## Model Structure

The model features:
- Two production sectors (brown and green)
- Environmental policy through carbon taxation
- Endogenous abatement decisions
- Capital allocation between sectors
- CES aggregation of sectoral outputs

## Output Files

The plots are saved as PDF files with names following the pattern:
`fig1_4_[variable].pdf` where [variable] is the economic variable being plotted. 