function e = find_KG(KG, para)

LB = para(1);
LG = para(2);
alphaG = para(3);
alphaB = para(4);
kappa = para(5);
theta = para(6);
p = para(7);
A = para(8);
varphi = para(9);
phi1 = para(10);
phi2 = para(11);
pZ = para(12);

KB =1 - KG;

% Cobb-Douglas production function in each sector
YG = A*KG^alphaG*LG^(1-alphaG);
YB = A*KB^alphaB*LB^(1-alphaB);

% Aggregation function
Y = (kappa*YB^((theta-1)/theta) + (1-kappa) *YG^((theta-1)/theta))^(theta/(theta-1));

% Demand functions
pB = kappa*(YB/Y)^(-1/theta)*p;
pG = (1-kappa)*(YG/Y)^(-1/theta)*p;

U = (varphi*pZ/phi1/phi2)^(1/(phi2-1));

% p = MC and demand  functions for capital and labor in brown sector 
Phi = pB - pZ*varphi*(1-U) - phi1*U^(phi2);
rB = Phi*alphaB*YB/KB;

rG = pG*alphaG*YG/KG;
e = rB - rG;
