clc;clear;

alphaB = 0.4; % The share of capital to production in brown sector
alphaG = 0.3; % The share of capital to production in green sector
p = 1; % The price of final goods
varphi = 0.5; % The scale of emissions function
phi1 = 1; % The parameter in the abatement cost function
phi2 = 2; % The parameter in the abatement cost function
A = 1; % TFP
kappa = 0.5; % The share of brown sector relative to green sctor
theta = 6; % The elsticity of substitution between brown and green sector

% specify here that LG = LB=1
LG = 1;
LB = 1;

% Create a 100x1 vector of carbon tax rates from 0 to 0.2
pZvec = linspace(0,0.2,100);

% Loop over each value of carbon tax rate considered
for i = 1:length(pZvec)
    
    % get different values of carbon tax rate for each loop
    pZ = pZvec(i);  

    % Use fsolve to solve for KB
    para = [LB, LG, alphaG, alphaB, kappa, theta, p, A, varphi, phi1, phi2, pZ];
    KG = fsolve(@(x) find_KG(x, para), 0.5);
    
    KB =1 - KG;
    
    % Cobb-Douglas production function in each sector
    YG = A*KG^alphaG*LG^(1-alphaG);
    YB = A*KB^alphaB*LB^(1-alphaB);
    
    % Aggregation function
    Y = (kappa*YB^((theta-1)/theta) + (1-kappa) *YG^((theta-1)/theta))^(theta/(theta-1));
    
    % Demand functions
    pB = kappa*(YB/Y)^(-1/theta)*p;
    pG = (1-kappa)*(YG/Y)^(-1/theta)*p;
    
    % Compute the abatement effort:
    U = (varphi*pZ/phi1/phi2)^(1/(phi2-1));
    
    % Demand functions for capital and labor in green sector 
    rG = pG*alphaG*YG/KG;
    wG = pG*alphaG*YG/LG;
    
    % p = MC and demand  functions for capital and labor in brown sector 
    Phi = pB - pZ*varphi*(1-U) - phi1*U^(phi2);
    rB = Phi*alphaB*YB/KB;
    wB = Phi*(1-alphaB)*YB/LB;
    
    % Emissions function
    Z = varphi*(1-U)*YB;

    Zvec(i) = Z;
    Uvec(i) = U;

    YBvec(i) = YB;
    YGvec(i) = YG;

    rBvec(i) = rB;
    rGvec(i) = rG;

    wBvec(i) = wB;
    wGvec(i) = wG;

    pBvec(i) = pB;
    pGvec(i) = pG;

    KBvec(i) = KB;
    KGvec(i) = KG;

    LBvec(i) = LB;
    LGvec(i) = LG;

    Yvec(i) = Y;

end

%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Plot the figure here
%1%%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, Zvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Emissions level $Z$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_Z.pdf') 
close
%2%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, Uvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Abatement effort $U$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_U.pdf') 
close
%3%%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, YBvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Brown Output $Y_B$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_YB.pdf') 
close
%4%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, YGvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Green Output $Y_G$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_YG.pdf') 
close
%5%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, rBvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Brown Capital Return $r_B$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_rB.pdf') 
close
%6%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, rGvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Green Capital Return $r_G$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_rG.pdf') 
close
%7%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, wBvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Brown Wage Rate $w_B$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_wB.pdf') 
close
%8%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, wGvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Green Wage Rate $w_G$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_wG.pdf') 
close
%9%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, pBvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Brown Price $p_B$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_pB.pdf') 
close
%10%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, pGvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Green Price $p_G$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_pG.pdf') 
close
%11%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, KBvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Brown Capital $K_B$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_KB.pdf') 
close
%12%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, KGvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Green Capital $K_G$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_KG.pdf') 
close
%13%%%%%%%%%%%%%%%%%%%%%%
figure_heading;
plot(pZvec, Yvec, 'k-', 'LineWidth', 1.5); 
xlabel('$p_Z$', 'FontSize', 18); 
title('Output $Y$', 'FontSize', 18); 
box off;
export_fig2(a1, 'fig1_4_Y.pdf') 
close


